/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.ImmutableMap;
import cz.insophy.inplan.planning.mokos.AbstractPlanningScorer;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import java.util.Objects;

public class IdScorer
extends AbstractPlanningScorer<Long> {
    private static final ImmutableMap<GeneralizedOrderRequest.State, Long> STATE_SCORE = ImmutableMap.builder().put(GeneralizedOrderRequest.State.PAUSED, 0L).put(GeneralizedOrderRequest.State.PLANNING, 0L).put(GeneralizedOrderRequest.State.PROPOSED, 0L).put(GeneralizedOrderRequest.State.RELEASED, 1L).put(GeneralizedOrderRequest.State.RUNNING, 0L).put(GeneralizedOrderRequest.State.VIRTUAL, 0L).put(GeneralizedOrderRequest.State.WILL_BE_RELEASED, 0L).build();

    public IdScorer() {
        super("id_score");
    }

    @Override
    protected Long getPlanningScore(Operation op, Operation.OperationPlanning planning) {
        GeneralizedActionRequest gar = op.getGar();
        GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
        Actiongram ag = gor.getSelectedActiongram();
        Action a = op.getAction();
        Workplace wp = Util.getFirstPlannedWa(planning).getWorkplace();
        long score = STATE_SCORE.get((Object)gor.getState()) << 33;
        score += (a.isMainLocalAlt() ? 1L : 0L) << 32;
        return score += (long)Objects.hash(gor.getId(), ag.getName(), a.getName(), a.getLocalAltName(), wp.getName());
    }
}

